<?php
// ===== CORS HEADERS =====
header("Access-Control-Allow-Origin: https://www.nosyradigital.com.ng");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

/**
 * Authentication Routes
 */

require_once __DIR__ . '/../../config/database.php'; // Adjust path to your Database class
require_once __DIR__ . '/../../config/jwt.php';      // Adjust path to your JWT class

function login() {
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate input
    if (!isset($input['username']) || !isset($input['password'])) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Username and password required'
        ]);
        return;
    }

    // Get DB connection
    $db = Database::getInstance()->getConnection();

    // Fetch user by username or email
    $query = "SELECT * FROM users WHERE username = :username OR email = :username";
    $stmt = $db->prepare($query);
    $stmt->execute([':username' => $input['username']]);
    $user = $stmt->fetch();

    // Verify credentials
    if (!$user || !password_verify($input['password'], $user['password'])) {
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'message' => 'Invalid credentials'
        ]);
        return;
    }

    // Create JWT token
    $payload = [
        'user_id' => $user['id'],
        'username' => $user['username'],
        'role' => $user['role'],
        'iat' => time(),
        'exp' => time() + JWT_EXPIRY
    ];

    $token = JWT::encode($payload);

    // Store session in database
    $sessionId = bin2hex(random_bytes(16));
    $sessionQuery = "INSERT INTO sessions (id, user_id, token, expires_at) 
                     VALUES (:id, :user_id, :token, FROM_UNIXTIME(:expires))";
    $sessionStmt = $db->prepare($sessionQuery);
    $sessionStmt->execute([
        ':id' => $sessionId,
        ':user_id' => $user['id'],
        ':token' => $token,
        ':expires' => $payload['exp']
    ]);

    // Respond with token and user data
    echo json_encode([
        'success' => true,
        'data' => [
            'token' => $token,
            'user' => [
                'id' => $user['id'],
                'username' => $user['username'],
                'name' => $user['name'],
                'email' => $user['email'],
                'role' => $user['role']
            ]
        ]
    ]);
}

/**
 * Route handler
 * Example: simple routing based on query param `action`
 * URL: /blog/routes/auth.php?action=login
 */
$action = $_GET['action'] ?? null;

switch ($action) {
    case 'login':
        login();
        break;
    default:
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'message' => 'Invalid route'
        ]);
        break;
}
