<?php
/**
 * Categories Routes
 */

function getCategories() {
    $db = Database::getInstance()->getConnection();
    
    $query = "SELECT 
                c.*,
                COUNT(p.id) as post_count
              FROM categories c
              LEFT JOIN posts p ON c.id = p.category_id AND p.status = 'published'
              GROUP BY c.id
              ORDER BY c.name ASC";
    
    $stmt = $db->query($query);
    $categories = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => $categories
    ]);
}

function getCategoryPosts($slug) {
    $db = Database::getInstance()->getConnection();
    
    // Get category
    $categoryQuery = "SELECT * FROM categories WHERE slug = :slug";
    $categoryStmt = $db->prepare($categoryQuery);
    $categoryStmt->execute([':slug' => $slug]);
    $category = $categoryStmt->fetch();
    
    if (!$category) {
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'message' => 'Category not found'
        ]);
        return;
    }
    
    // Get posts for this category
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $limit = POSTS_PER_PAGE;
    $offset = ($page - 1) * $limit;
    
    $postsQuery = "SELECT 
                    p.id, p.title, p.slug, p.excerpt, p.featured_image,
                    p.published_at, p.views,
                    u.name as author_name
                   FROM posts p
                   LEFT JOIN users u ON p.author_id = u.id
                   WHERE p.category_id = :category_id AND p.status = 'published'
                   ORDER BY p.published_at DESC
                   LIMIT :limit OFFSET :offset";
    
    $postsStmt = $db->prepare($postsQuery);
    $postsStmt->bindValue(':category_id', $category['id'], PDO::PARAM_INT);
    $postsStmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $postsStmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $postsStmt->execute();
    
    $posts = $postsStmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => [
            'category' => $category,
            'posts' => $posts
        ]
    ]);
}